//
// TRACKER SCHEME RESOURCE FILE ***** EDITED by INsane [dodbits] 2023 https://sturmbot.org/index.php/dod-turtorials/day-of-defeat-customisation-guides
//                              ***** This is for Scoreboard font correction.https://sturmbot.org/index.php/dod-turtorials/day-of-defeat-customisation-guides/116-editing-the-dod-1-3-scoreboard#fixfonts
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
// notes:
// 		hit ctrl-alt-shift-R in the app to reload this file 
//
Scheme
{
	//Name - currently overriden in code
	//{
	//	"Name"	"ClientScheme"
	//}

	//////////////////////// COLORS /////////////////////////// INsane's NOTE no colors edited in this version, just fonts. Help text is added to other sections.
	Colors
	{
		// base colors
		"BaseText"			"255 176 0 255"		// Used in text windows, lists Team Menu title, Class Menus titles, top spec bar fonts. (orange/yellow)
		"BrightBaseText"	"255 176 0 255"		// brightest (selected) text - color of arrow when mouse is over button - Command Menu (PRESS X to activate) text and arrows are affected too
		"SelectedText"		"255 176 0 255"		   	// (no effect on HUD found) selected text (orange/yellow)
		"DimBaseText"		"255 176 0 255"		// dim base text (orange/yellow) Command Menu and Specator panels UNselected text colour
		"LabelDimText"		"255 176 0 164"			// (no effect on HUD found) used for info text  (orange/yellow, 46% transparent)
		"ControlText"		"255 176 0 255"		// Text controls	(orange/yellow) e.g: Bottom Spec' bar - OPTIONS - HELP its the text color of the panel
	//	"BrightControlText"	"255 176 0 255"		// use for selected controls	 (orange/yellow) OLD Valve edit - disabled. (orange/yellow)
		"BrightControlText"	"255 255 255 255"	// use for selected controls (full white)  New Valve edit
		"DisabledText1"		"80 48 0 255"		 	// (no effect on HUD found) disabled text  (medium brown)
		"DisabledText2"		"0 0 0 0"			 	// (no effect on HUD found) overlay color for disabled text (to give that inset look) (black, 100% transparent so... OFF)
		"DimListText"		"188 112 0 255"		 	// (no effect on HUD found) offline friends, unsubscribed games, etc. (medium orange)

		// background colors
		"ControlBG"			"0 0 0 0"		  // background color of controls	(black, 100% transparent OFF) handy for finding out the panel sizes. Use "255 102 204 100" Open the game to see what it does. 
		"ControlDarkBG"		"0 0 0 128"		  // darker background color; used for background of scrollbars 	(black, 50% transparent)
		"WindowBG"			"0 0 0 200"		  // (black, 22% transparent) Background color of text panels Team, Class, COMMAND MENU	
		"SelectionBG"		"192 28 0 140"    // (medium red, 45% transparent) Command Menu Background of "lit" or selected item (button)
		"SelectionBG2"		"128 128 128 64"  // Scoreboard - selection background in window w/o focus (Places a colour over YOUR name only) 	(medium grey, 75% transparent)
		"ListBG"			"0 0 0 128"		  // Scoreboard -  background of scoreboard
		"ViewportBG"		"55 43 29 140"    // Game Background when in a panel like MOTD, Team, Class  (dark brown, 45% transparent)

		// titlebar colors
		"TitleText"			"255 174 0 255"		//(No effect seen) 	(orange/yellow)
		"TitleDimText"		"255 174 0 255"		//(No effect seen) 	(orange/yellow)
		"TitleBG"			"255 255 0 0"		//(No effect seen) (bright yellow, 100% transparent so ...its OFF))
		"TitleDimBG"		"255 255 0 0"   	//(No effect seen) 	(bright yellow, 100% transparent so ...its OFF)
		
		// slider tick colors
		"SliderTickColor"	"127 140 127 255"	// (No effect seen) 	(medium blueish/grey)
		"SliderTrackColor"	"31 31 31 255"     	// (No effect seen) 	(very dark grey)

		// border colors
		"BorderBright"		"64 52 36 255"    	//(Brown) the lit side (right/bottom) of a control Panel and opposite for scroll bars, Panels team, ScoreBoard
		"BorderDark"		"64 52 36 255"    	//(Brown) the dark/unlit (Left/top) side of a control Panel and opposite for scroll bars, Panels team, ScoreBoard
		"BorderSelection"	"188 112 0 0"     	//(Tan - yellow) Buttons like special "Map Description" in command menu or bot' spec' contols "help".

		"team0"			"255 179 0 255"			// Spectators		    (orange/yellow) Changes color on the Join Team panel ONLY... bottom the spectators
		"team1"			"76 102 76 255"			// Allies/British	    (medium green/grey) Changes color on the Join Team panel ONLY... bottom the Allied players
		"team2"			"255 64 64 255"	    	// Axis			        (bright red/pink) Changes color on the Join Team panel ONLY... bottom the Axis players
		"team3"			"255 179 0 255"			// Not-used in dod		(orange/yellow)
		"team4"			"255 179 0 255"			// Not-used in dod		(orange/yellow)

		"HintColor"		"255 255 255 160"    	// Mugsy the dog Hint panel colour - Hint box border	(white and around 30% transparent)
		"HintBackgroundColor"	"0 0 0 128"  	// As above area - Hint box background	(black and 50% transparent) 
		
 		//new class menu colours Shared by many other controls - changing them here will cause strange behaviour. Better to give specific controls specific colours in the BASE SETTINGS section.
		"ClassMenuLight"	"175 127 1 255" 	//	(medium TAN) Background of Panel Buttons if selected. Team, Class (and the left insert colour in weapons power)  also the BG of the "lit" Command Menu Button "Map Description" button
		"ClassMenuDark"		"64 52 36 255"      //	(dark brown) The divider lines in Panels Team, Class (and the right insert colour in weapons power) also the BG of the Command Menu Button "Map Description" button
		"white"				"255 255 255 255"   //	(full white)
		"red"				"255 0 0 255"       //	(full red)
		"nothing"			"0 0 0 0"           //  (this is blank all zeros)

		"MapDescriptionText"	"255 255 255 255" // the text used in the map description window? (full white)
	}

	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		"FgColor"			"ControlText"	// default foreground colour
		"BgColor"			"ControlBG"		// default background colour
		"LabelBgColor"		"ControlBG"		// default label background colour
		"SubPanelBgColor"	"ControlBG"		// default sub-panel background colour

		"DisabledFgColor1"		"DisabledText1" 
		"DisabledFgColor2"		"DisabledText2"			// set this to the BgColor if you don't want it to draw

		"TitleBarFgColor"			"TitleText"
		"TitleBarDisabledFgColor"	"TitleDimText"
		"TitleBarBgColor"			"TitleBG"
		"TitleBarDisabledBgColor"	"TitleDimBG"

		"TitleBarIcon"				"resource/icon_steam"
		"TitleBarDisabledIcon"		"resource/icon_steam_disabled"

		"TitleButtonFgColor"			"BorderBright"
		"TitleButtonBgColor"			"ControlBG"
		"TitleButtonDisabledFgColor"	"TitleDimText"
		"TitleButtonDisabledBgColor"	"TitleDimBG"

		"TextCursorColor"			"BaseText"			// color of the blinking text cursor in text entries
		"URLTextColor"				"BrightBaseText"	// color that URL's show up in chat window

		Menu    // The pop-up in-game menu with 'map info, map description, etc.' on it
		{
			"FgColor"			"DimBaseText"
			"BgColor"			"ControlBG"
			"ArmedFgColor"		"BrightBaseText"
			"ArmedBgColor"		"SelectionBG"
			"DividerColor"		"BorderDark"
			"TextInset"			"6"
		}

		MenuButton	  // the little arrow on the side of boxes that triggers drop down menus - Command menu.
		{
			"ButtonArrowColor"	"DimBaseText"		// color of arrows
		   	"ButtonBgColor"		"WindowBG"			// bg color of button. same as background color of text edit panes 
			"ArmedArrowColor"	"BrightBaseText"	// color of arrow when mouse is over button - Command Menu (PRESS X to activate) text and arrows are affected 
			"ArmedBgColor"		"DimBaseText"		// bg color of button when mouse is over button
		}

		Slider           // These don't do anything - in dod 1.3 HUD - OLD?
		{
			"SliderFgColor"		"ControlBG"			// handle with which the slider is grabbed
			"SliderBgColor"		"ControlDarkBG"		// area behind handle
		}

		ScrollBarSlider
		{
			"BgColor"					"ControlBG"		// this isn't really used
			"ScrollBarSliderFgColor"	"ControlBG"		// handle with which the slider is grabbed
			"ScrollBarSliderBgColor"	"ControlDarkBG"	// area behind handle
			"ButtonFgColor"				"DimBaseText"	// color of arrows
		}


		// Text edit windows - descriptions but there is some redundant stuff here too.
		"WindowFgColor"				"BaseText"		// off-white
		"WindowBgColor"				"WindowBG"		// redundant. can we get rid of WindowBgColor and just use WindowBG?
		"WindowDisabledFgColor"		"DimBaseText"
		"WindowDisabledBgColor"		"ListBG"		// background of chat conversation
		"SelectionFgColor"			"SelectedText"	// fg color of selected text
		"SelectionBgColor"			"SelectionBG"
		"ListSelectionFgColor"		"SelectedText"
		"ListBgColor"				"ListBG"		// background of server browser control, etc
		"BuddyListBgColor"			"ListBG"		// background of buddy list pane
		
		// App-specific stuff
		"ChatBgColor"				"WindowBG"

		// status selection
		"StatusSelectFgColor"		"BrightBaseText"
		"StatusSelectFgColor2"		"BrightControlText"	// this is the color of the friends status

		// checkboxes
		"CheckButtonBorder1"   		"BorderDark"		// the left checkbutton border
		"CheckButtonBorder2"   		"BorderBright"		// the right checkbutton border
		"CheckButtonCheck"			"BrightControlText"	// color of the check itself
		"CheckBgColor"				"ListBG"

		//  buttons (default fg/bg colors are used if these are not set)- WARNING! Some DoD controls seem to ignore these values!
		"ButtonArmedFgColor"		"BrightControlText"
		"ButtonArmedBgColor"		"ClassMenuLight"
		"ButtonDepressedFgColor"	"BrightControlText"
		"ButtonDepressedBgColor"	"ClassMenuLight"

		"ButtonFgColor"				"BrightControlText"
		"ButtonBgColor"				"ClassMenuDark"
	
		// buddy buttons
		BuddyButton
		{
			"FgColor1"				"ControlText"
			"FgColor2"				"DimListText"
			"ArmedFgColor1"			"BrightBaseText"
			"ArmedFgColor2"			"BrightBaseText"
			"ArmedBgColor"			"SelectionBG"
		}

		Chat
		{
			"TextColor"				"BrightControlText"
			"SelfTextColor"			"BaseText"
			"SeperatorTextColor"	"DimBaseText"
		}

		"SectionTextColor"		"BrightControlText"	// text color for IN-GAME, ONLINE, OFFLINE sections of buddy list
		"SectionDividerColor"	"BorderDark"		// color of line that runs under section name in buddy list
	}

	//
	//////////////////////// FONTS //***INsane's note*** - edited standard fonts are still there you will see a "//" of what was cut out
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
//		"Default"
//		{
//			"1"
//			{
//				"name"		"Times New Roman"
//				"tall"		"13"
//				"weight"	"400"
//				"antialias"		"1"
//			}
		"Default"  // *EDITED* - Multi Resolution Heights included - Alters - OK button, Map info, Hint text, Scoreboard title and names (not subtitles)
		{
			"1"		// Typical sizes 4:3 640X480 - 16:9 Wide 720x480 720X576 - 21:9 ultra wide 720X480
			{
				"name"		"Verdana" 
				"tall"		"13"        // "12"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"480 599"		// Screen Height Range, Between 480 X 599 only
				"antialias"		"1"				
				"dropshadow"	"1"
			}
			"2"  	// Typical sizes 4:3 800X600 - 16:9 Wide 1280x600 1200x720 1360X768 - 21:9 ultra wide 1280X720 1680X720
			{
				"name"		"Verdana"
				"tall"		"14"        // "13"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. "
				"yres"	"600 767"		// Screen Height Range, Between 600 X 767 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"3"  	// Typical sizes 4:3 1024X768 to 1280X960 - 16:9 Wide   - 21:9 ultra wide 
			{
				"name"		"Verdana"
				"tall"		"15"        // "14"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"768 1023"		// Screen Height Range, Between 768 X 1024 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"4"  	// Typical sizes 4:3  1400X1050 - 16:9 Wide 1920X1080 - 21:9 ultra wide 2560X1080
			{
				"name"		"Verdana"
				"tall"		"22"        //"20"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1024 1199"		// Screen Height Range, Between 1024 X 1199 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"5"  	// Typical sizes 4:3 1600X1200 - 16:9 Wide 2560x1440 and 3840 x 2160 - 21:9 ultra wide 3440X1440 32:9 
			{
				"name"		"Verdana"
				"tall"		"24"        // "24"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1200 6000"		// Screen Height Range, Between 1200 X 6000  
				"antialias"		"1"					
				"dropshadow"	"1"
			}
		}
		"DefaultPlus"  // *ADDED* - For any area that needs a (slightly) larger "Verdana" like the Scoreboard
		{
			"1"		// Typical sizes 4:3 640X480 - 16:9 Wide 720x480 720X576 - 21:9 ultra wide 720X480
			{
				"name"		"Verdana" 
				"tall"		"14"        // "12"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"480 599"		// Screen Height Range, Between 480 X 599 only
				"antialias"		"1"				
				"dropshadow"	"1"
			}
			"2"  	// Typical sizes 4:3 800X600 - 16:9 Wide 1280x600 1200x720 1360X768 - 21:9 ultra wide 1280X720 1680X720
			{
				"name"		"Verdana"
				"tall"		"15"        // "13"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. "
				"yres"	"600 767"		// Screen Height Range, Between 600 X 767 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"3"  	// Typical sizes 4:3 1024X768 to 1280X960 - 16:9 Wide   - 21:9 ultra wide 
			{
				"name"		"Verdana"
				"tall"		"16"        // "14"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"768 1023"		// Screen Height Range, Between 768 X 1024 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"4"  	// Typical sizes 4:3  1400X1050 - 16:9 Wide 1920X1080 - 21:9 ultra wide 2560X1080
			{
				"name"		"Verdana"
				"tall"		"24"        //"20"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1024 1199"		// Screen Height Range, Between 1024 X 1199 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"5"  	// Typical sizes 4:3 1600X1200 - 16:9 Wide 2560x1440 and 3840 x 2160 - 21:9 ultra wide 3440X1440 32:9 
			{
				"name"		"Verdana"
				"tall"		"26"        // "24"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1200 6000"		// Screen Height Range, Between 1200 X 6000  
				"antialias"		"1"					
				"dropshadow"	"1"
			}
		}		
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"500"
				"underline" "1"
			}
		}
		"DefaultSmall"  // For scoreboard headings - added scaling font
		{
			"1"
			{
				"name"		"Times New Roman"
				"tall"		"13"
				"weight"	"800"
			}
		}
		"DefaultVerySmall"    // For scoreboard headings - added scaling font and changed the font type.
		{
			"1"		// Typical sizes 4:3 640X480 - 16:9 Wide 720x480 720X576 - 21:9 ultra wide 720X480
			{
				"name"		"Verdana" 
				"tall"		"12"        // "12"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"480 599"		// Screen Height Range, Between 480 X 599 only
				"antialias"		"1"				
				"dropshadow"	"1"
			}
			"2"  	// Typical sizes 4:3 800X600 - 16:9 Wide 1280x600 1200x720 1360X768 - 21:9 ultra wide 1280X720 1680X720
			{
				"name"		"Verdana"
				"tall"		"13"        // "13"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. "
				"yres"	"600 767"		// Screen Height Range, Between 600 X 767 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"3"  	// Typical sizes 4:3 1024X768 to 1280X960 - 16:9 Wide   - 21:9 ultra wide 
			{
				"name"		"Verdana"
				"tall"		"15"        // "14"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"768 1023"		// Screen Height Range, Between 768 X 1024 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"4"  	// Typical sizes 4:3  1400X1050 - 16:9 Wide 1920X1080 - 21:9 ultra wide 2560X1080
			{
				"name"		"Verdana"
				"tall"		"20"        //"20"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1024 1199"		// Screen Height Range, Between 1024 X 1199 only
				"antialias"		"1"					
				"dropshadow"	"1"
			}
			"5"  	// Typical sizes 4:3 1600X1200 - 16:9 Wide 2560x1440 and 3840 x 2160 - 21:9 ultra wide 3440X1440 32:9 
			{
				"name"		"Verdana"
				"tall"		"24"        // "24"
				"weight"	"550"		//(def) For adjusting bold, 600 is bold, 550 or less will make the font thin. 
				"yres"	"1200 6000"		// Screen Height Range, Between 1200 X 6000  
				"antialias"		"1"					
				"dropshadow"	"1"
			}
		}

		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}

		"ClassMenuDefault"
		{
			"1"
			{
				"name"		"Times New Roman"
				"tall"		"15"
				"weight"	"400"
				"antialias"		"1"
			}
		}

		"ClassMenuTitleFont"
		{
			"1"
			{
				"name"		"Times New Roman"
				"tall"		"20"
				"weight"	"500"		//bold 0 - 1000
				"antialias"	"1"
			}
		}

		"ClassMenuBoldFont"
		{
			"1"
			{
				"name"		"Times New Roman"
				"tall"		"11"
				"weight"	"800"		//bold 0 - 1000
				"antialias"	"1"
			}
		}

		"ClassMenuBodyFont"
		{
			"1"
			{
				"name"		"Times New Roman"
				"tall"		"13"
				"weight"	"500"		//bold 0 - 1000
				"antialias"	"1"
			}
		}
		//"HudFont"
	//	{
		//	"1"
		//	{
		//		"name"		"Times New Roman"
		//		"tall"		"10"
		//		"weight"	"500"		//bold 0 - 1000
		//		"antialias"	"1"
		//	}
		//}

		
		"HudFontSmall"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"10"
				"weight"	"600"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"10"
				"range" 		"0x0000 0x00FF"
				"weight"		"600"
				"dropshadow"	"1"
			}
		}

		"HudFont"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"12"
				"weight"	"600"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"600"
				"dropshadow"	"1"
			}
		}

		"HudFontBig"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"16"
				"weight"	"600"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"16"
				"range" 		"0x0000 0x00FF"
				"weight"		"600"
				"dropshadow"	"1"
			}
		}
		
	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		BaseBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"4"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		ButtonDepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}
		}

		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}
		}

		ButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "nothing"
					"offset" "0 0"
				}
			}
		}

		FrameBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}
		}

		HintBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "HintColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "HintColor"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "HintColor"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "HintColor"
					"offset" "0 0"
				}
			}
		}


		TabBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 1"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ComboBoxBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		MenuBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}
		BrowserBorder
		{
			"inset" "0 0 0 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
	}
}